/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Data
{
    internal static class StringHelperClass
    {
        /// <summary>
        /// This method is used to replace most calls to the Java String.split method.
        /// </summary>
        /// <param name="source"></param>
        /// <param name="delimiter"></param>
        /// <param name="trimEmpty"></param>
        /// <returns></returns>
        internal static string[] StringSplit(string source, string delimiter, bool trimEmpty)
        {
            string[] splitArray = System.Text.RegularExpressions.Regex.Split(source, delimiter);

            if (trimEmpty)
            {
                if (splitArray.Length > 1)
                {
                    for (int i = splitArray.Length; i > 0; i--)
                    {
                        if (splitArray[i - 1].Length > 0)
                        {
                            if (i < splitArray.Length)
                                System.Array.Resize(ref splitArray, i);

                            break;
                        }
                    }
                }
            }
            return splitArray;
        }
    }
}